Attribute VB_Name = "DialogCustomization"
Option Explicit

Private Declare Function RedrawWindow Lib "user32.dll" ( _
     ByVal hwnd As Long, _
     lprcUpdate As Any, _
     ByVal hrgnUpdate As Long, _
     ByVal fuRedraw As Long) As Long
Private Const RDW_ALLCHILDREN = &H80
Private Const RDW_INVALIDATE = &H1
Private Const RDW_UPDATENOW = &H100

Public Declare Function FindWindowEx Lib "user32.dll" Alias "FindWindowExA" ( _
     ByVal hWnd1 As Long, _
     ByVal hWnd2 As Long, _
     ByVal lpsz1 As String, _
     ByVal lpsz2 As String) As Long

Private Declare Function GetDlgCtrlID Lib "user32.dll" ( _
     ByVal hwnd As Long) As Long

Private Declare Function GetDesktopWindow Lib "user32.dll" () As Long

Private Declare Function EnableWindow Lib "user32.dll" ( _
    ByVal hwnd As Long, _
    ByVal fEnable As Long) As Long

Private Declare Function DestroyWindow Lib "user32.dll" ( _
    ByVal hwnd As Long) As Long

Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long

Public Declare Function SetWindowLong Lib "user32.dll" Alias "SetWindowLongA" ( _
    ByVal hwnd As Long, _
    ByVal nIndex As Long, _
    ByVal dwNewLong As Long) As Long

Public Const GWL_STYLE = (-16)
Public Const WS_CAPTION = &HC00000
Public Const WS_SYSMENU = &H80000
Public Const WS_POPUP = &H80000000
Public Const WS_CHILD = &H40000000
Public Const WM_SETTEXT = &HC
Public Const WM_GETTEXT = &HD
Public Const WM_GETTEXTLENGTH = &HE

Public Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Public Type POINTAPI
    x As Long
    y As Long
End Type

' Hook and notification support:
Public Type NMHDR
    hwndFrom As Long
    idfrom As Long
    code As Long
End Type

Public Type OFNOTIFYshort
    hdr As NMHDR
    lpOFN As Long
End Type

Public Declare Function GetWindowText Lib "user32.dll" Alias "GetWindowTextA" ( _
    ByVal hwnd As Long, _
    ByVal lpString As String, _
    ByVal cch As Long) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Public Declare Function GetParent Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Public Declare Function MoveWindow Lib "user32" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Public Declare Function ScreenToClient Lib "user32" (ByVal hwnd As Long, lpPoint As POINTAPI) As Long
Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (lpvDest As Any, lpvSource As Any, ByVal cbCopy As Long)
Public Declare Function EndDialog Lib "user32" (ByVal hDlg As Long, ByVal nResult As Long) As Long

Private Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
Private Declare Function GetClassName Lib "user32" Alias "GetClassNameA" (ByVal hwnd As Long, ByVal lpClassName As String, ByVal nMaxCount As Long) As Long
Private Declare Function SetParent Lib "user32" (ByVal hWndChild As Long, ByVal hWndNewParent As Long) As Long

Public Const GW_CHILD = 5
Public Const GW_HWNDFIRST = 0
Public Const GW_HWNDNEXT = 2

Public Const WM_INITDIALOG = &H110
Public Const WM_USER = &H400
Public Const WM_DESTROY = &H2
Public Const WM_NOTIFY = &H4E
Public Const WM_COMMAND = &H111
Public Const WM_LBUTTONDOWN = &H201
Public Const WM_LBUTTONUP = &H202
Public Const WM_CLOSE As Long = &H10

Public Const CDM_FIRST = (WM_USER + 100)
Public Const CDM_SETCONTROLTEXT = (CDM_FIRST + &H4)
Public Const CDM_HIDECONTROL = (CDM_FIRST + &H5)
Public Const CDM_GETSPEC = (CDM_FIRST + &H0)
Public Const CDM_GETFILEPATH = (CDM_FIRST + &H1)
Public Const CDM_GETFOLDERPATH = (CDM_FIRST + &H2)

Private Const H_MAX As Long = &HFFFF + 1
Private Const CDN_FIRST = (H_MAX - 601)
Private Const CDN_SELCHANGE = (CDN_FIRST - &H1)
Private Const CDN_FOLDERCHANGE = (CDN_FIRST - &H2)
Private Const CDN_HELP = (CDN_FIRST - &H4)
Private Const CDN_FILEOK As Long = (CDN_FIRST - &H5)
Private Const CDN_TYPECHANGE = (CDN_FIRST - 6&)

Private Const ID_OPEN = &H1  'Open or Save button
Private Const ID_CANCEL = &H2 'Cancel Button
Private Const ID_HELP = &H40E 'Help Button
Private Const ID_FILETYPELABEL = &H441 'FileType label
Private Const ID_FILELABEL = &H442 'FileName label
Private Const ID_FOLDERLABEL = &H443 'Folder label
Private Const ID_FILETEXT = &H480 'FileName text box
'Private Const ID_READONLY = &H410 'Read-only check box
'Private Const ID_LIST = &H461 'Parent of file list
'Private Const ID_FORMAT = &H470 'FileType combo box
'Private Const ID_FOLDER = &H471 'Folder combo box

Private Const SW_NORMAL = 1
Private Const WM_PASTE = &H302
Private Const WM_SHOWWINDOW = &H18
Private Const WM_WINDOWPOSCHANGING = &H46
Private Const WM_WINDOWPOSCHANGED = &H47
Private Const WM_SIZE = &H5

'        -     ModifyDlg:
Public oldWidth As Long, oldHeight As Long ' <<    
Public lbHeight As Long
Public toolbarHeight As Long
Public navTbWidth As Long
Public cboExTop As Long, cboExLeft As Long
Public cboTypeTop As Long, cboTypeLeft As Long
Public openLeft As Long, openTop As Long
Public helpTop As Long
Public cancelLeft As Long, cancelTop As Long
Public statFileTop As Long
Public statFTypeTop As Long
Public rtbTop As Long

Public CDlg As CdlgEx
Public imageInfo As New CImageInfo
Public rtb As RichTextBox
Public TwipsInHimetric As Single
Public comLab As TextBox
Public comText As TextBox
Public chkView As CheckBox
Public imgInfo As TextBox
Public DlgHwnd As Long
Public globalHDlg As Long
Public openHwnd As Long     ' <<   "";    
Public cancelHwnd As Long   ' <<   ""; ,    WM_DESTROY  rtb
Public helpHwnd As Long     ' <<   "" (        )
Public toolbarHwnd As Long  ' <<         (  "Places Bar")
Public navTbHwnd As Long    ' <<      "", " "  ..
Public cboExHwnd As Long    ' <<   (ComboBoxEx32)  MRU- 
Public cboHwnd As Long      ' <<     
Public cboTypeHwnd As Long  ' <<     
Public slvHwnd As Long      ' <<  SysListView32,     ,  
Public lbHwnd As Long       ' <<  
Dim sPath As String

Public Function lHookAddress(lPtr As Long) As Long
    lHookAddress = lPtr
End Function

Public Function DialogHookFunction(ByVal hDlg As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    ''   Debug.Print wMsg
    Const BM_CLICK As Long = &HF5
    Dim st As String, currentComm As String, fN As Integer, commFile As String
    Dim sLength As Long  ' length of the window text
    Dim retVal As Long   ' return value of message
    Dim ret As Integer, sTmp As String
    Dim rez As Long, currentState As Long
    
    If globalHDlg = 0 Then globalHDlg = hDlg

    Select Case wMsg
            '   ( ):
            '
            ' WM_INITDIALOG
            ' WM_SHOWWINDOW
            ' WM_WINDOWPOSCHANGING
            ' WM_WINDOWPOSCHANGED
            ' WM_SIZE

        Case WM_SHOWWINDOW
            '' Debug.Print "WM_SHOWWINDOW"
            
        Case WM_WINDOWPOSCHANGING
            '' Debug.Print "WM_WINDOWPOSCHANGING"
               
        Case WM_WINDOWPOSCHANGED
            '' Debug.Print "WM_WINDOWPOSCHANGED"
          
        Case WM_SIZE
            '' Debug.Print "WM_SIZE"
            
        Case WM_INITDIALOG
            '' Debug.Print "WM_INITDIALOG"
            
            '   ()  :
            Dim rct As RECT
            DlgHwnd = GetParent(hDlg)
            GetWindowRect DlgHwnd, rct
            oldWidth = rct.Right - rct.Left
            oldHeight = rct.Bottom - rct.Top
            
            MoveDlg hDlg
            ModifyDlg hDlg, True
            ReDim buttArr(0 To 0)
            AddMyButton
            AddNewServiceButtons
            OldWndProc = SetWindowLong(DlgHwnd, GWL_WNDPROC, AddressOf WindowProc)
            
        Case WM_NOTIFY
            Dim tOFNs As OFNOTIFYshort
            Dim tNMH As NMHDR
            CopyMemory tNMH, ByVal lParam, Len(tNMH)
               
            If tNMH.code = CDN_SELCHANGE Then
                ' Debug.Print "CDN_SELCHANGE"
                
                EnableWindow helpHwnd, 1
                sTmp = String(259, 0)
                ret = SendMessage(GetParent(hDlg), CDM_GETFILEPATH, 260, ByVal sTmp)
                
                If ret > 1 Then
                    
                    sPath = Left$(sTmp, ret - 1)
                    ' Debug.Print sPath
                    ViewFile sPath ' <<    (  RichEdit)
                    If InStr(1, sPath, ".bmp", vbTextCompare) > 0 Then
                        commFile = Replace$(sPath, ".bmp", ".txt", , , vbTextCompare)
                    ElseIf InStr(1, sPath, ".jpg", vbTextCompare) > 0 Then
                        commFile = Replace$(sPath, ".jpg", ".txt", , , vbTextCompare)
                    Else
                        commFile = ""
                    End If
                    If commFile <> "" Then
                        If Dir(commFile) <> "" Then
                            '   
                            fN = FreeFile
                            Open commFile For Binary Access Read As #fN
                            currentComm = String$(1000, vbNullChar)
                            Get #fN, , currentComm
                            Close #fN
                            currentComm = Left$(currentComm, InStr(1, currentComm, vbNullChar) - 1)
                            currentComm = Replace$(currentComm, vbCrLf, " ")
                            comText.Text = currentComm
                            SendMessage DlgHwnd, CDM_SETCONTROLTEXT, ID_HELP, ByVal CDlg.HelpText
                            EnableWindow helpHwnd, 1
                        Else
                            comText.Text = ""
                            SendMessage DlgHwnd, CDM_SETCONTROLTEXT, ID_HELP, ByVal "< "
                            EnableWindow helpHwnd, 1
                        End If
                    Else
                        comText.Text = ""
                        EnableWindow helpHwnd, 0
                    End If
                Else
                    comText.Text = ""
                    EnableWindow helpHwnd, 0
                End If
               
            ElseIf tNMH.code = CDN_FOLDERCHANGE Or tNMH.code = CDN_TYPECHANGE Then
                
                rtb.Text = ""
                comText.Text = ""
                imgInfo.Text = ""
                EnableWindow helpHwnd, 0
                SendMessage cboExHwnd, WM_SETTEXT, 0, ByVal 0& ' <<  
                
                If tNMH.code = CDN_FOLDERCHANGE Then
                    ' Debug.Print "CDN_FOLDERCHANGE"
                    
                    sTmp = String(259, 0)
                    ret = SendMessage(GetParent(hDlg), CDM_GETFOLDERPATH, 260, ByVal sTmp)
                    ' Debug.Print "sTmp = ", sTmp
                    If ret > 1 Then
                        sPath = Left$(sTmp, ret - 1)
                        If LCase$(sPath) = LCase$(CDlg.InitDir) Then
                            '   :
                            currentState = SendMessageLong(toolbarHwnd, TB_GETSTATE, IDC_MYBUTTON, 0)
                            currentState = currentState And (Not TBSTATE_CHECKED)
                            retVal = SendMessageLong(toolbarHwnd, TB_SETSTATE, IDC_MYBUTTON, currentState)
                            SendMessageLong toolbarHwnd, TB_PRESSBUTTON, IDC_MYBUTTON, 1
                        Else
                            '   :
                            SendMessageLong toolbarHwnd, TB_PRESSBUTTON, IDC_MYBUTTON, 0
                        End If
                        '     ,           
                        '   (. ) - 4   .   :  - ,  .
                    Else
                        ' ret = 0 -->     " ", " ";  
                        '   :
                        SendMessageLong toolbarHwnd, TB_PRESSBUTTON, IDC_MYBUTTON, 0
                    End If
                End If
                
            ElseIf tNMH.code = CDN_HELP Then
               
                '    :
                sLength = SendMessage(comText.hwnd, WM_GETTEXTLENGTH, ByVal CLng(0), ByVal CLng(0)) + 1
                currentComm = Space$(sLength)
                retVal = SendMessage(comText.hwnd, WM_GETTEXT, ByVal sLength, ByVal currentComm)
                ' Remove the terminating null and extra space from the buffer:
                currentComm = Left(currentComm, retVal)
                st = InputBox$("   :", "", currentComm)
                If st <> "" And st <> currentComm Then
                    '   :
                    sTmp = String(259, 0)
                    ret = SendMessage(GetParent(hDlg), CDM_GETFILEPATH, 260, ByVal sTmp)
                    If ret > 1 Then
                        sPath = Left$(sTmp, ret - 1)
                        If InStr(1, sPath, ".bmp", vbTextCompare) > 0 Then
                            commFile = Replace$(sPath, ".bmp", ".txt", , , vbTextCompare)
                        ElseIf InStr(1, sPath, ".jpg", vbTextCompare) > 0 Then
                            commFile = Replace$(sPath, ".jpg", ".txt", , , vbTextCompare)
                        Else
                            commFile = ""
                        End If
                        If commFile <> "" Then
                            fN = FreeFile
                            Open commFile For Output As #fN
                            Print #fN, st
                            Close #fN
                            Clipboard.SetText st, vbCFText
                            SendMessage comText.hwnd, WM_SETTEXT, 0, ByVal 0& ' <<  
                            SendMessage comText.hwnd, WM_PASTE, 0, 0
                            Clipboard.Clear
                        End If
                    End If
                End If
                
            ElseIf tNMH.code = CDN_FILEOK Then
                ' Debug.Print "CDN_FILEOK"
                
                '   rtb -   WM_DESTROY !!!  - .
                rtb.Locked = False
                rtb.Text = ""
                rtb.Locked = True
            End If
            
        Case WM_DESTROY
            ' Debug.Print "WM_DESTROY"
            
            toolbarHeight = 0
            navTbWidth = 0
            cboExTop = 0
            cboExLeft = 0
            cboTypeTop = 0
            cboTypeLeft = 0
            rtbTop = 0
            statFileTop = 0
            statFTypeTop = 0
            openTop = 0
            helpTop = 0
            cancelTop = 0
            lbHeight = 0
            
        Case Else
            '' Debug.Print ">>>", tNMH.code
    End Select
End Function

Public Sub MoveDlg(ByVal hDlg As Long)
    Dim rct As RECT, dx As Long, dy As Long, screenWidth As Long, screenHeight As Long
    Dim trayHwnd As Long, trayRect As RECT, trayWidth As Long, trayHeight As Long
  
    If CDlg.Left = 0 And CDlg.Top = 0 Then Exit Sub
    
    If CDlg.CenterOnScreen Then
        '    ,   CDlg.Left  CDlg.Top:
        
        dx = (Screen.Width / Screen.TwipsPerPixelX - oldWidth * CDlg.RatioX) / 2
        dy = (Screen.Height / Screen.TwipsPerPixelY - oldHeight * CDlg.RatioY) / 2
        MoveWindow DlgHwnd, dx, dy, oldWidth * CDlg.RatioX, oldHeight * CDlg.RatioY, 1
    
    ElseIf CDlg.FitScreen Then
        '    ;   -      CDlg.RatioX  CDlg.RatioY:
        
        screenWidth = Screen.Width / Screen.TwipsPerPixelX
        screenHeight = Screen.Height / Screen.TwipsPerPixelY
        
        ' ,      -    :
        trayHwnd = FindWindowEx(GetDesktopWindow, ByVal 0&, "Shell_TrayWnd", vbNullString)
        GetWindowRect trayHwnd, trayRect
        With trayRect
            trayWidth = .Right - .Left
            trayHeight = .Bottom - .Top
        End With
        
        If trayWidth > trayHeight Then
            '      - :
            screenHeight = screenHeight - trayHeight
        Else
            '    :
            screenWidth = screenWidth - trayWidth
        End If
        
        CDlg.RatioX = screenWidth / oldWidth
        CDlg.RatioY = screenHeight / oldHeight
        CDlg.Left = 0
        CDlg.Top = 0
        MoveWindow DlgHwnd, CDlg.Left, CDlg.Top, screenWidth, screenHeight, 1
    
    Else
        '     CDlg.Left  CDlg.Top:
        
        MoveWindow DlgHwnd, CDlg.Left, CDlg.Top, oldWidth * CDlg.RatioX, oldHeight * CDlg.RatioY, 1
    
    End If
End Sub

Public Sub ModifyDlg(ByVal hDlg As Long, ByVal embedNewControls As Boolean)
    Const ImgInfoWidth As Long = 170&
    Dim sClass As String
    Dim h As Long, i As Long, k As Long, hh As Long
    Dim pt As POINTAPI, bDone As Boolean, tEdge As Long
    Dim rEdge As Long, rct As RECT, lbRC As RECT
    Dim st As String, ctlRect As RECT, buttonWidth As Long, imgInfoOffset As Long
    Dim cboTop As Long, cboLeft As Long, cboH As Long, statLeft As Long, helpLeft As Long
    Dim navTbRight As Long, chkLeft As Long, rtbRect As RECT
  
''    DlgHwnd = GetParent(hDlg)  ' <<       -  WM_INITDIALOG; ,  
                                 '    "  "  , GetParent -   !!!
    GetWindowRect DlgHwnd, rct
  
    If CDlg.OKText <> "" Then SendMessage DlgHwnd, CDM_SETCONTROLTEXT, ID_OPEN, ByVal CDlg.OKText
    If CDlg.CancelText <> "" Then SendMessage DlgHwnd, CDM_SETCONTROLTEXT, ID_CANCEL, ByVal CDlg.CancelText
    If CDlg.HelpText <> "" Then SendMessage DlgHwnd, CDM_SETCONTROLTEXT, ID_HELP, ByVal CDlg.HelpText
    
    '    GetWindow    .     
    '  ,  , -          :
    h = FindWindowEx(DlgHwnd, ByVal 0&, "Button", CDlg.OKText)
    GetWindowRect h, ctlRect
    buttonWidth = ctlRect.Right - ctlRect.Left
    
    '    :
    h = GetWindow(DlgHwnd, GW_CHILD)
    Do
        
        sClass = Space$(128)
        k = GetClassName(h, ByVal sClass, 128)
        sClass = Left$(sClass, k)
'         Debug.Print h, Hex(h), sClass
        
        If sClass = "ComboBox" And Not bDone Then  ' <<   
            bDone = True
            GetWindowRect h, ctlRect
            rEdge = ctlRect.Right - 1
            cboHwnd = h
            
        Else
            If sClass = "ListBox" Then
                lbHwnd = h
                GetWindowRect h, lbRC
                pt.x = lbRC.Left
                pt.y = lbRC.Top
                tEdge = lbRC.Top
''                Debug.Print "lbRC >>>", "Left=" & lbRC.Left, "Right=" & lbRC.Right, "Top=" & lbRC.Top, "Bottom=" & lbRC.Bottom
                ScreenToClient DlgHwnd, pt
                If lbHeight = 0 Then lbHeight = (lbRC.Bottom - lbRC.Top)
                MoveWindow h, pt.x, pt.y, rEdge - lbRC.Left, lbHeight + oldHeight * (CDlg.RatioY - 1), 1
            End If
            
            If sClass = "SHELLDLL_DefView" Then ' <<     ModifyDlg     -   "SysListView32", 
                GetWindowRect h, ctlRect
                With ctlRect
                    pt.x = .Left
                    pt.y = .Top
                    ScreenToClient DlgHwnd, pt
                    MoveWindow h, pt.x, pt.y, rEdge - ctlRect.Left, lbHeight + oldHeight * (CDlg.RatioY - 1), 1
                    RedrawWindow DlgHwnd, ByVal 0&, ByVal 0&, RDW_INVALIDATE + RDW_UPDATENOW + RDW_ALLCHILDREN ' << !!!
                End With
            End If
            
            If sClass = "ComboBox" Then ' <<    
                GetWindowRect h, ctlRect
                With ctlRect
                    pt.x = .Left
                    pt.y = .Top
                    ScreenToClient DlgHwnd, pt
                    If cboTypeTop = 0 Then cboTypeTop = pt.y: cboTypeLeft = pt.x
                    MoveWindow h, pt.x, cboTypeTop + oldHeight * (CDlg.RatioY - 1), _
                       rct.Right - .Left - buttonWidth - 12, .Bottom - .Top, 1
                    cboLeft = pt.x
                    cboTop = cboTypeTop + oldHeight * (CDlg.RatioY - 1)
                    cboH = .Bottom - .Top
                    cboTypeHwnd = h
                End With
            End If
         
            ' :
            '
            ' If sClass = "SysListView32" Then
            '     GetWindowRect h, lbRC
            '     pt.x = lbRC.Left
            '     pt.y = lbRC.Top
            '     tEdge = lbRC.Top
            '     ScreenToClient DlgHwnd, pt
            '     MoveWindow h, pt.x, pt.y, rEdge - lbRC.Left, (lbRC.Bottom - lbRC.Top) + oldHeight * (CDlg.RatioY - 1), 1
            '     slvHwnd = h
            ' End If
            '
            '  -    - -     !
            '    (slvHwnd)   ,  ToolBarModule.WindowProc,    .
            
            If sClass = "Button" Then
                GetWindowRect h, ctlRect
                With ctlRect
                    pt.x = rct.Right - (.Right - .Left) - 7 ' <<    
                    pt.y = .Top
                    ScreenToClient DlgHwnd, pt
                    Select Case WindowTitle(h)
                        Case CDlg.OKText
                            '   ""
                            openHwnd = h
                            If openTop = 0 Then openTop = pt.y
                            MoveWindow h, pt.x, openTop + oldHeight * (CDlg.RatioY - 1), .Right - .Left, .Bottom - .Top, 1
                        Case CDlg.CancelText
                            '   ""
                            cancelHwnd = h
                            If cancelTop = 0 Then cancelTop = pt.y
                            MoveWindow h, pt.x, cancelTop + oldHeight * (CDlg.RatioY - 1), .Right - .Left, .Bottom - .Top, 1
                        Case CDlg.HelpText
                            '   ""
                            helpHwnd = h
                            EnableWindow helpHwnd, 0
                            helpLeft = pt.x
                            If helpTop = 0 Then helpTop = pt.y
                            MoveWindow h, pt.x, helpTop + oldHeight * (CDlg.RatioY - 1), .Right - .Left, .Bottom - .Top, 1
                        Case Else
                            ' nothing
                    End Select
                End With
            End If
         
            '      OFNexplorer ,      -  ComboBoxEx32, 
            '   "" - Edit.
            If sClass = "ComboBoxEx32" Then
                GetWindowRect h, ctlRect
                With ctlRect
                    pt.x = .Left
                    pt.y = .Top
                    ScreenToClient DlgHwnd, pt
                    If cboExTop = 0 Then cboExTop = pt.y: cboExLeft = pt.x
                    ' MoveWindow h, pt.x, pt.Y + oldHeight * (CDlg.RatioY - 1), rEdge - .Left, .Bottom - .Top, 1
                    MoveWindow h, pt.x, cboExTop + oldHeight * (CDlg.RatioY - 1), _
                       rct.Right - .Left - buttonWidth - 12, .Bottom - .Top, 1
                    cboExHwnd = h
                End With
            End If
         
            '    (""  ,  )     :
         
            ' If sClass = "Edit" Then
            '     GetWindowRect h, ctlRect
            '     With ctlRect
            '         pt.x = .Left
            '         pt.y = .Top
            '         ScreenToClient DlgHwnd, pt
            '         MoveWindow h, pt.x, pt.y + oldHeight * (CDlg.RatioY - 1), rEdge - .Left, .Bottom - .Top, 1
            '     End With
            ' End If
        
            If sClass = "ToolbarWindow32" Then
                GetWindowRect h, ctlRect
                pt.x = ctlRect.Left
                pt.y = ctlRect.Top
                If (ctlRect.Right - ctlRect.Left) < (ctlRect.Bottom - ctlRect.Top) Then
                    '    -    ("Places Bar")
                    ScreenToClient DlgHwnd, pt
                    If toolbarHeight = 0 Then toolbarHeight = (ctlRect.Bottom - ctlRect.Top)
                    MoveWindow h, pt.x, pt.y, ctlRect.Right - ctlRect.Left, toolbarHeight + oldHeight * (CDlg.RatioY - 1), 1
                    toolbarHwnd = h
                    ' Debug.Print "toolbarHwnd = ", toolbarHwnd
                Else
                    '    (  ""  ..)
                    ScreenToClient DlgHwnd, pt
                    If navTbWidth = 0 Then navTbWidth = ctlRect.Right - ctlRect.Left
                    MoveWindow h, pt.x, pt.y, navTbWidth + 5, ctlRect.Bottom - ctlRect.Top, 1
                    navTbHwnd = h
                    navTbRight = pt.x + ctlRect.Right - ctlRect.Left + 5
                    ' Debug.Print "navTbHwnd = ", navTbHwnd
                End If
            End If

            If sClass = "Static" Then  ' <<  
                GetWindowRect h, ctlRect
                With ctlRect
                    pt.x = .Left
                    pt.y = .Top
                    ScreenToClient DlgHwnd, pt
                    Select Case GetDlgCtrlID(h)
                        Case ID_FOLDERLABEL
                            '   "" -   
                        Case ID_FILELABEL
                            If statFileTop = 0 Then statFileTop = pt.y
                            MoveWindow h, pt.x, statFileTop + oldHeight * (CDlg.RatioY - 1), .Right - .Left, .Bottom - .Top, 1
                        Case ID_FILETYPELABEL
                            If statFTypeTop = 0 Then statFTypeTop = pt.y
                            MoveWindow h, pt.x, statFTypeTop + oldHeight * (CDlg.RatioY - 1), .Right - .Left, .Bottom - .Top, 1
                            statLeft = pt.x
                        Case Else
                            ' nothing
                    End Select
                End With
            End If
            
        End If
        h = GetWindow(h, GW_HWNDNEXT)
    Loop While h <> 0
    
    If embedNewControls Then  ' <<     
        
        '   :
        SetParent rtb.hwnd, DlgHwnd
        rtb.Visible = True
        pt.x = rEdge + 3
        pt.y = tEdge - 1
        ScreenToClient DlgHwnd, pt
        If rtbTop = 0 Then rtbTop = pt.y
        rtb.Text = ""
        GetWindowRect rtb.hwnd, rtbRect
        
        SetParent comText.hwnd, DlgHwnd
        comText.Visible = True
        comText.Text = ""
        
        SetParent comLab.hwnd, DlgHwnd
        comLab.Visible = True
    
        SetParent chkView.hwnd, DlgHwnd
        chkView.Visible = True
    
        SetParent imgInfo.hwnd, DlgHwnd
        imgInfo.Visible = True
        imgInfo.Text = "..."
    
    End If
    
    '     -    :
    
    pt.x = rEdge + 3
    pt.y = tEdge - 1
    ScreenToClient DlgHwnd, pt
    MoveWindow rtb.hwnd, pt.x, rtbTop, rct.Right - rEdge - 8, lbHeight + oldHeight * (CDlg.RatioY - 1) + 2, 1

    GetWindowRect comText.hwnd, ctlRect
    With ctlRect
        pt.x = .Left
        pt.y = .Top
        ScreenToClient DlgHwnd, pt
        MoveWindow comText.hwnd, cboLeft, cboTop + 28, helpLeft - cboLeft - 5, cboH, 1
    End With

    GetWindowRect comLab.hwnd, ctlRect
    With ctlRect
        pt.x = .Left
        pt.y = .Top
        ScreenToClient DlgHwnd, pt
        MoveWindow comLab.hwnd, statLeft, (cboTop + 28) + 2, .Right - .Left, .Bottom - .Top, 1
    End With

    GetWindowRect chkView.hwnd, ctlRect
    With ctlRect
        pt.x = rct.Right - (.Right - .Left) - 7 ' <<    
        pt.y = .Top
        ScreenToClient DlgHwnd, pt
        '     :
        MoveWindow chkView.hwnd, pt.x, 11, .Right - .Left, .Bottom - .Top, 1
        chkLeft = pt.x
    End With
    chkView.Value = Val(ReadINIKey("Common", "FitScreen", iniFile))

    GetWindowRect imgInfo.hwnd, ctlRect
    With ctlRect
        pt.x = .Left
        pt.y = .Top
        ScreenToClient DlgHwnd, pt
        '   imgInfo   .   -:
        imgInfoOffset = ((chkLeft - navTbRight) - ImgInfoWidth) / 2
        MoveWindow imgInfo.hwnd, navTbRight + imgInfoOffset, 11, ImgInfoWidth, .Bottom - .Top, 1
    End With

End Sub

Private Sub ViewFile(sFile As String)
    DoEvents
    If Dir$(sFile, vbArchive Or vbHidden Or vbNormal Or vbReadOnly Or vbSystem) = "" Then
        rtb.Text = ""
        comText.Text = ""
        EnableWindow helpHwnd, 0
        SendMessage cboExHwnd, WM_SETTEXT, 0, ByVal 0& ' <<  
        Exit Sub
    End If
    If (GetAttr(sFile) And vbDirectory) = vbDirectory Then
        rtb.Text = ""
        comText.Text = ""
        EnableWindow helpHwnd, 0
        SendMessage cboExHwnd, WM_SETTEXT, 0, ByVal 0& ' <<  
        Exit Sub
    End If
    rtb.Locked = False
    rtb.Font.Size = 8
    rtb.Text = ""
    rtb.SelAlignment = 0
    rtb.RightMargin = 0
    On Error GoTo ErrHandler
    Select Case LCase$(Right$(sFile, 4))
        Case ".bmp", ".jpg", ".gif", ".rle", ".wmf", ".emf"
            Dim pic As StdPicture
            LockWindowUpdate rtb.hwnd
            Set pic = LoadPicture(sPath)
            Clipboard.Clear
            Clipboard.SetData pic
            SendMessage rtb.hwnd, WM_PASTE, 0, 0
            Clipboard.Clear
            rtb.RightMargin = pic.Width \ TwipsInHimetric
            LockWindowUpdate 0&
            With imageInfo
                .ReadImageInfo sPath
                imgInfo.Text = "  : " & .Width & "  " & .Height & ", : " & .Depth & " "
            End With
        Case ".rtf"
            rtb.LoadFile sPath, rtfRTF
            imgInfo.Text = ""
        Case ".txt"
            rtb.LoadFile sPath, rtfText
            imgInfo.Text = ""
        Case Else
            imgInfo.Text = ""
            If FileLen(sFile) < 100000 Then
                rtb.LoadFile sPath, rtfText
            Else
                rtb.Text = "    "
            End If
    End Select
    rtb.Refresh
    rtb.Locked = True
    Exit Sub
ErrHandler:
    On Error GoTo 0
    rtb.Text = "This format is not supported"
    rtb.Refresh
    rtb.Locked = True
End Sub

